# SelectionSort
# sorting by direct selection

# Nach Eingabe einer natuerlichen Zahl n und der
# Zuweisung von Zufallszahlen an die n Komponenten
# des Arrays a wird das Array a sortiert.

from random import randint
import time

n = int(input('Anzahl der Datenelemente = '))
r = int(input('Wieviele Elemente sollen angezeigt werden? '))

# Erzeugen des arrays mit dem Namen a 
# und den n Komponenten a[0], . . . , a[n-1]
a = list(range(1,n+1))

# Zuweisung von Zufallszahlen an die Komponenten der Liste a
for i in range(0,n):
    a[i] = randint(1,1000000)

# Ausgabe der Quelliste:
print()
print('Quelliste:')
for i in range(0,r):
    print(a[i])


# Sortieren der Quelliste
# Fuer jeden Wert j = 0, . . . , n-2 wird zunaechst derjenige
# Index 'indexmin' bestimmt, für den a[indexmin]
# den kleinsten Wert innerhalb der Liste a[j], . . . , a[n-1] hat.
# Anschließend erfolgt einmalig der "swap", indem die Inhalte
# von a[j] und a[indexmin] einander getauscht werden.

start = time.time()

j = 0
while j <= n-2:
   indexmin = j
   i = j + 1
   while i < n:
      if a[i] < a[indexmin]: indexmin = i
      i = i + 1
   # swap   
   temp        = a[indexmin]
   a[indexmin] = a[j]
   a[j]        = temp     
   j = j + 1

end = time.time()

         
# Ausgabe der sortierten Liste:
print()
print('sortierte Liste:')
for i in range(0,r):
    print(a[i])

print()
print('Zeitaufwand zum Sortieren von',n,'Elementen: {:7.3f} s'.format(end-start))   
